<?php $__env->startSection('content'); ?>
    <h3 class="page-title">Appointments </h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('working_hour_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.working_hours.create')); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('quickadmin.qa_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.css' />

	<style>
	.fc-time-grid-event.fc-short .fc-time span {
    display: inline;
}

.fc-time-grid-event.fc-short .fc-time:before {
    content: normal;
}  

.fc-time-grid-event.fc-short .fc-time:after {
    content: normal;
}
</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/qtip2/3.0.3/jquery.qtip.css" rel="stylesheet"/>
    <div id='calendar'></div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>
   

<script src="https://cdnjs.cloudflare.com/ajax/libs/qtip2/3.0.3/jquery.qtip.js"></script>



   <script>
        $(document).ready(function() {
            // page is now ready, initialize the calendar...
            $('#calendar').fullCalendar({
                // put your options and callbacks here
               // defaultView: 'agendaWeek',
			   //timeFormat: 'HH:mm { - HH:mm}',

                events : [
                    <?php $__currentLoopData = $working_hours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        title : '<?php echo e($hour->name); ?>',
                        start : '<?php echo e($hour->date . ' ' . $hour->start_time); ?>',
                        end : '<?php echo e($hour->date . ' ' . $hour->finish_time); ?>',
                        url : '<?php echo e(route('admin.working_hours.edit', $hour->id)); ?>'
                    },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
				
				  eventRender: function(event, element) {
					  
    element.qtip({
      content: 	'<b>' + event.start.format('hh:mma') + ' - ' + event.end.format('hh:mma') + '</b>' +
        	'<br>' +
        	'<u>' + event.title + '</u>'
    });
  }

            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>