<?php $__env->startSection('content'); ?>
    <h3 class="page-title">Owners</h3>
    
    <?php echo Form::model($owner, ['method' => 'PUT', 'route' => ['admin.owners.update', $owner->id]]); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('quickadmin.qa_edit'); ?>
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('owner_code', 'Owner Code', ['class' => 'control-label']); ?>

                    <?php echo Form::text('owner_code', old('owner_code'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('owner_code')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('owner_code')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('owner_name', 'Owner Name', ['class' => 'control-label']); ?>

                    <?php echo Form::text('owner_name', old('owner_name'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('owner_name')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('owner_name')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
      
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('owner_email', 'Owner Email', ['class' => 'control-label']); ?>

                    <?php echo Form::email('owner_email', old('owner_email'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('owner_email')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('owner_email')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('quickadmin.qa_update'), ['class' => 'btn btn-danger']); ?>

    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>