<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('quickadmin.appointments.title'); ?> - Import</h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('appointment_create')): ?>
        
    <?php endif; ?>

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.css' />

    <div id='calendar_div'>
	
                        <input type="hidden"
                               name="_token"
                               value="<?php echo e(csrf_token()); ?>">

                        <div class="form-group">
                            <label class="col-md-4 control-label">File:</label>

                            <div class="col-md-6">
                                <input type="file"
                                       class="form-control"
                                       name="xls"
                                       value="">
                            </div>
                        </div>
<br>
<br>

<div class="form-group">
</div>
                      

                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-4">
                                <button type="submit"
                                        class="btn btn-primary"
                                        style="margin-right: 15px;">
                                    Submit
                                </button>
                            </div>
                        </div>
                    
	</div>

    <br />

	
	
	<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('appointment_delete')): ?>
            window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.appointments.mass_destroy')); ?>';
        <?php endif; ?>

    </script>

    <script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>
    <script>
        $(document).ready(function() {
            // page is now ready, initialize the calendar...
            $('#calendar').fullCalendar({
                // put your options and callbacks here
                defaultView: 'agendaWeek',
                events : [
                        <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        title : '<?php echo e($appointment->client->first_name . ' ' . $appointment->client->last_name); ?>',
                        start : '<?php echo e($appointment->start_time); ?>',
                        <?php if($appointment->finish_time): ?>
                                end: '<?php echo e($appointment->finish_time); ?>',
                        <?php endif; ?>
                        url : '<?php echo e(route('admin.appointments.edit', $appointment->id)); ?>'
                    },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>