@extends('layouts.app')

@section('content')
    <h3 class="page-title">{{$page_title}} </h3>
    @can('taskmanager_create')
    <p>
        <a href="{{ route('admin.taskmanager.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

	
		<div class="row">
<div class="col-xs-12 form-group">

    {!! Form::open(['method' => 'POST', 'route' => ['admin.reports.task']]) !!}

    <div class="panel panel-default">
     
        
        <div class="panel-body">
       
			
		     <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('owner_id', 'Owner', ['class' => 'control-label']) !!}
				
				
				{!! Form::select('owner_id', $owner, old('owner_id'), ['class' => 'form-control select2']) !!}
			</div>
          </div>
			
			
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('employee_id', 'Employee*', ['class' => 'control-label']) !!}
						{!! Form::select('employee_id', $employees, old('employee_id'), ['class' => 'form-control select2']) !!}
                </div>
            </div>
			

            			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('progress_status', 'Job Status', ['class' => 'control-label']) !!}
				
					{!! Form::select('progress_status', $status, old('progress_status'), ['class' => 'form-control select2']) !!}
			</div>
          </div>
      
			
			
	
            
        </div>
    </div>

    {!! Form::submit('Search', ['class' => 'btn btn-danger']) !!}
    {!! Form::close() !!}
</div>
</div>


    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($tasks) > 0 ? 'datatable' : '' }} @can('taskmanager_delete') dt-select @endcan">
                <thead>
                    <tr>
                        @can('taskmanager_delete')
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        @endcan

                        <th>Company</th>
                        <th>Owner</th>
                        <th>Segment</th>
						<th>Employee</th>
						
						  <th> Meeting</th>
                        <th>Meeting Date</th>
                        <th>Deadline</th>
						<th>Review Date</th>
						
                        <th>Status</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($tasks) > 0)
                        @foreach ($tasks as $task)
                            <tr data-entry-id="{{ $task->id }}">
                                @can('taskmanager_delete')
                                    <td></td>
                                @endcan

                                <td>{{ $task->company_id}} </td>
                                <td>{{ $task->owner_id }}</td>
                                
                                <td>{{ $task->segment_id }}</td>
								<td>{{ $task->employee_id }}</td>
								
								<td>{{ $task->type_of_meeting}} </td>
                                <td>{{ $task->meeting_date }}</td>
                                
                                <td>{{ $task->deadline }}</td>
								<td>{{ $task->review_date }}</td>
								
								
								
								
								@if ($task->progress_status == 'Completed' && 
								 $task->approved ==1)
								<td style="background:green">{{ $task->progress_status }}
								
								<br>
									<a href="{{ url('admin/task/status/'.$task->id) }}" 
								 class="btn btn-xs btn-primary"> Remarks </a>
								</td>
								
								 @elseif ($task->progress_status == 'Completed' && 
								 $task->approved !=1)
								<td style="background:red">{{ $task->progress_status }}
								<br>
									<a href="{{ url('admin/task/status/'.$task->id) }}" 
								 class="btn btn-xs btn-primary"> Remarks </a>
								</td>
								@else 
								<td>{{ $task->progress_status }}
							<br>
									<a href="{{ url('admin/task/status/'.$task->id) }}" 
								 class="btn btn-xs btn-primary"> Remarks </a>
							</td>	
								@endif
								
								
                                <td>
                                    @can('taskmanager_view')
                                    <a href="{{ route('admin.taskmanager.show',[$task->id]) }}" class="btn btn-xs btn-primary">@lang('quickadmin.qa_view')</a>
                                    @endcan
                                    @can('taskmanager_edit')
                                    <a href="{{ route('admin.taskmanager.edit',[$task->id]) }}" class="btn btn-xs btn-info">@lang('quickadmin.qa_edit')</a>
                                    @endcan
                                    @can('taskmanager_delete')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.taskmanager.destroy', $task->id])) !!}
                                    {!! Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
									 @if ($task->progress_status == 'Completed')
									@can('taskmanager_approve')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("Are you sure to approve")."');",
                                        'route' => ['admin.task_import.destroy', $task->id])) !!}
                                    {!! Form::submit(trans('Approve'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
									@endif
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('javascript') 
    <script>
        @can('owner_delete')
            window.route_mass_crud_entries_destroy = '{{ route('admin.taskmanager.mass_destroy') }}';
        @endcan

    </script>
@endsection