@extends('layouts.app')

@section('content')
    <h3 class="page-title">{{$page_title}} </h3>
    @can('owner_create')
    <p>
        <a href="{{ route('admin.taskmanager.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($tasks) > 0 ? 'datatable' : '' }} @can('owner_delete') dt-select @endcan">
                <thead>
                    <tr>
                        @can('owner_delete')
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        @endcan

                        <th>Company</th>
                        <th>Owner</th>
                        <th>Segment</th>
						<th>Employee</th>
						
						  <th> Meeting</th>
                        <th>Meeting Date</th>
                        <th>Deadline</th>
						<th>Review Date</th>
						
                        <th>Status</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($tasks) > 0)
                        @foreach ($tasks as $task)
                            <tr data-entry-id="{{ $task->id }}">
                                @can('owner_delete')
                                    <td></td>
                                @endcan

                                <td>{{ $task->company_id}} </td>
                                <td>{{ $task->owner_id }}</td>
                                
                                <td>{{ $task->segment_id }}</td>
								<td>{{ $task->employee_id }}</td>
								
								<td>{{ $task->type_of_meeting}} </td>
                                <td>{{ $task->meeting_date }}</td>
                                
                                <td>{{ $task->deadline }}</td>
								<td>{{ $task->review_date }}</td>
								
								
								
								
								<td>{{ $task->progress_status }}</td>
                                <td>
                                    @can('owner_view')
                                    <a href="{{ route('admin.taskmanager.show',[$task->id]) }}" class="btn btn-xs btn-primary">@lang('quickadmin.qa_view')</a>
                                    @endcan
                                    @can('owner_edit')
                                    <a href="{{ route('admin.taskmanager.edit',[$task->id]) }}" class="btn btn-xs btn-info">@lang('quickadmin.qa_edit')</a>
                                    @endcan
                                    @can('owner_delete')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.taskmanager.destroy', $task->id])) !!}
                                    {!! Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('javascript') 
    <script>
        @can('owner_delete')
            window.route_mass_crud_entries_destroy = '{{ route('admin.taskmanager.mass_destroy') }}';
        @endcan

    </script>
@endsection