@extends('layouts.app')

@section('content')
    <h3 class="page-title">Task Manager</h3>
    @can('taskmanager_create')
    <p>
        <a href="{{ route('admin.taskmanager.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.css' />

    <div id='calendar'></div>

@stop

@section('javascript')
    <script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>
    <script>
        $(document).ready(function() {
            // page is now ready, initialize the calendar...
            $('#calendar').fullCalendar({
                // put your options and callbacks here
                //defaultView: 'agendaWeek',
                events : [
                    @foreach($taskmanager as $hour)
                    {
                        title : '{{ $hour->company_id . ' ' . $hour->employee_id }}',
                        start : '{{ $hour->meeting_date . '' }}',
                        end : '{{ $hour->meeting_date . ''  }}',
                        url : '{{ route('admin.taskmanager.edit', $hour->id) }}'
                    },
                    @endforeach
                ]
            })
        });
    </script>
@endsection