@extends('layouts.app')

@section('content')
    <h3 class="page-title">Owners</h3>
    @can('owner_create')
    <p>
        <a href="{{ route('admin.owners.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($owners) > 0 ? 'datatable' : '' }} @can('owner_delete') dt-select @endcan">
                <thead>
                    <tr>
                        @can('owner_delete')
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        @endcan

                        <th>Owner Code</th>
                        <th>Owner Name</th>
                        <th>Email</th>
                       
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($owners) > 0)
                        @foreach ($owners as $owner)
                            <tr data-entry-id="{{ $owner->id }}">
                                @can('owner_delete')
                                    <td></td>
                                @endcan

                                <td>{{ $owner->owner_code}}</td>
                                <td>{{ $owner->owner_name }}</td>
                                
                                <td>{{ $owner->owner_email }}</td>
                                <td>
                                    @can('owner_view')
                                    <a href="{{ route('admin.owners.show',[$owner->id]) }}" class="btn btn-xs btn-primary">@lang('quickadmin.qa_view')</a>
                                    @endcan
                                    @can('owner_edit')
                                    <a href="{{ route('admin.owners.edit',[$owner->id]) }}" class="btn btn-xs btn-info">@lang('quickadmin.qa_edit')</a>
                                    @endcan
                                    @can('owner_delete')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.owners.destroy', $owner->id])) !!}
                                    {!! Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('javascript') 
    <script>
        @can('owner_delete')
            window.route_mass_crud_entries_destroy = '{{ route('admin.owners.mass_destroy') }}';
        @endcan

    </script>
@endsection