<?php

namespace App\Http\Controllers\Admin;

use App\WorkingHour;
use App\Taskmanager;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreWorkingHoursRequest;
use App\Http\Requests\Admin\UpdateWorkingHoursRequest;

use Carbon\Carbon;
use DateTime;
use DateInterval;

use DB;


class WorkingHoursController extends Controller
{
    /**
     * Display a listing of WorkingHour.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }

        //$working_hours = WorkingHour::all();
		
		$user = \Auth::user();
		
		//if($user->role_id==1)
        //{	
		$working_hours = DB::table('working_hours as wh' )
            ->select('u.name as name', 'wh.date','wh.id' ,'wh.start_time','wh.finish_time')
            ->join('users as u', 'u.id', '=', 'wh.owner_id')
            //->where('u.user_code', '=', $user->user_code)

            ->get();
	   /* }
				else if($user->role_id ==3)
        {	
	
	    
		$working_hours = DB::table('working_hours as wh' )
            ->select('u.name as name', 'wh.date','wh.id' ,'wh.start_time','wh.finish_time')
            ->join('users as u', 'u.id', '=', 'wh.owner_id')
          //  ->where('wh.owner_id', '=', $user->id)

            ->get();
	
	
		}*/
		
	
		

        return view('admin.working_hours.index', compact('working_hours'));
    }

    /**
     * Show the form for creating new WorkingHour.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('working_hour_create')) {
            return abort(401);
        }
        $relations = [
             //'employees' => \App\Employee::get(),
			 'owners' => \App\User::where('role_id',2)->get(),
			 'status' => \App\Status::get(),
        ];

        return view('admin.working_hours.create', $relations);
    }

    /**
     * Store a newly created WorkingHour in storage.
     *
     * @param  \App\Http\Requests\StoreWorkingHoursRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreWorkingHoursRequest $request)
    {
        if (! Gate::allows('working_hour_create')) {
            return abort(401);
        }
        $working_hour = WorkingHour::create($request->all());



        return redirect()->route('admin.working_hours.index');
    }


    /**
     * Show the form for editing WorkingHour.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('working_hour_edit')) {
            return abort(401);
        }
        $relations = [
           // 'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
		   'owners' => \App\User::where('role_id',2)->get()->pluck('name','id')->prepend('Please select', ''),
			'status' => \App\Status::get()->pluck('name', 'name')->prepend('Please select', ''),
        ];

        $working_hour = WorkingHour::findOrFail($id);
		
		//echo $working_hour->owner_id;
		//exit;

        return view('admin.working_hours.edit', compact('working_hour') + $relations);
    }

    /**
     * Update WorkingHour in storage.
     *
     * @param  \App\Http\Requests\UpdateWorkingHoursRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateWorkingHoursRequest $request, $id)
    {
        if (! Gate::allows('working_hour_edit')) {
            return abort(401);
        }
        $working_hour = WorkingHour::findOrFail($id);
        $working_hour->update($request->all());



        return redirect()->route('admin.working_hours.index');
    }


    /**
     * Display WorkingHour.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (! Gate::allows('working_hour_view')) {
            return abort(401);
        }
		$owners=\App\User::where('id',2)->get();
		
		
        $relations = [
           // 'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
		   'owner' => $owners[0]->name,
        ];

        $working_hour = WorkingHour::findOrFail($id);
		
		
        return view('admin.working_hours.show', compact('working_hour') + $relations);
    }


    /**
     * Remove WorkingHour from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('working_hour_delete')) {
            return abort(401);
        }
        $working_hour = WorkingHour::findOrFail($id);
        $working_hour->delete();

        return redirect()->route('admin.working_hours.index');
    }

    /**
     * Delete all selected WorkingHour at once.
     *
     * @param Request $request
     */
    public function massDestroy(Request $request)
    {
        if (! Gate::allows('working_hour_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = WorkingHour::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
	
	
   public function appointment_today()
    {
		$page_title='Appointments-Today';       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		//$appointments = WorkingHour::where('date', '=', $today_date)->get();
		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		//->whereBetween('date', array($lastweek_start, $weekEndDate))

        ->where('date', $today_date)
		->orderBy('h.id')
		->get();
		

       return view('admin.reports.index', compact('appointments','page_title'));
    }
	
	   public function appointment_todaypendding()
    {
		$page_title='Appointments-Pending';
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		//$appointments = WorkingHour::where('date', '=', $today_date)->where('status', '!=' ,'Completed')->get();
		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		//->whereBetween('date', array($lastweek_start, $weekEndDate))

        ->where('date', $today_date)
		->where('status',  '!=','Completed')
		->orderBy('h.id')
		->get();
		
		

       return view('admin.reports.index', compact('appointments','page_title'));
    }
	
    public function appointment_todaycompleted()
    {
		$page_title='Appointments-Completed';
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		//$appointments = WorkingHour::where('date', '=', $today_date)->where('status', '=' ,'Completed')->get();
		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		//->whereBetween('date', array($lastweek_start, $weekEndDate))

        ->where('date', $today_date)
		->where('status', 'Completed')
		->orderBy('h.id')
		->get();

       return view('admin.reports.index', compact('appointments','page_title'));
    }

	
	
	
	
	
    public function task_reports()
    {
		$page_title='Task - Reports';
		       
	   if (! Gate::allows('taskmanager_access')) {
            return abort(401);
        }
		/*$today_date=date('Y-m-d');
		$tasks = Taskmanager::where('deadline', '=', $today_date)->get();
		
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   //$tasks = Taskmanager::whereBetween('deadline', [$weekStartDate, $weekEndDate])->get();
	   
	   
	   */
	   
	   		$user = \Auth::user();
		   	
			
       if($user->role_id==1)
        {	
		
	   $tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
            ->join('users as u', 'u.user_code', '=', 't.employee_id');
	    }
				else if($user->role_id ==2)
        {	
	
	    
			$tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
			->join('users as u', 'u.user_code', '=', 't.owner_id')
            ->where('u.user_code', '=', $user->user_code);

            
			
	
		
		}
		
		else if($user->role_id ==3)
        {	
	
	    
		$tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
			->join('users as u', 'u.user_code', '=', 't.employee_id')
            ->where('u.user_code', '=', $user->user_code);

            
	
	
		}
     		


        $tasks =    $tasks1->get();
		        $relations = [
		   // 'owner' => \App\Owner::get(),
		   
		    'owner' => \App\User::where('role_id',2)->get(),
		    //'company' => \App\Company::get(),
		    //'segments' => \App\Segment::get(),
            'status' => \App\Status::get(),
            'employees' => \App\User::where('role_id',3)->get(),
			//'meeting' => \App\Meeting::get(),
        ];
    
        //return view('admin.taskmanager.create', compact('segments') +$relations);

       return view('admin.reports.task_report', compact('tasks','page_title')+$relations);
    }
	
	public function task_today()
    {
		$page_title='Task - Today';
		
		$user = \Auth::user();
		$role_id=$user->role_id;
		$user_code=$user->user_code;
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->get();
		
		if($role_id==2)
		{
					
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('employee_id', '=', $user_code)->get();
		}  
		
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   //$tasks = Taskmanager::whereBetween('deadline', [$weekStartDate, $weekEndDate])->get();

       return view('admin.reports.task', compact('tasks','page_title'));
    }

	
	public function task_todaycompleted()
    {
		$page_title='Task - Completed';
		$user = \Auth::user();
		$role_id=$user->role_id;
		$user_code=$user->user_code;
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '=' ,'Completed')->get();
		
		if($role_id==2)
		{
					
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '=' ,'Completed')->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '=' ,'Completed')->where('employee_id', '=', $user_code)->get();
		}  
		
		

       return view('admin.reports.task', compact('tasks','page_title'));
    }

	
	public function task_todaypending()
    {
		$page_title='Task - Pending';
		$user = \Auth::user();
		$role_id=$user->role_id;
		$user_code=$user->user_code;

		
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$today_date=date('Y-m-d');
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '!=' ,'Completed')->get();
		
		if($role_id==2)
		{
					
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '!=' ,'Completed')->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::where('meeting_date', '=', $today_date)->where('progress_status', '!=' ,'Completed')->where('employee_id', '=', $user_code)->get();
		}  

       return view('admin.reports.task', compact('tasks','page_title'));
    }
	
	public function weekly_task()
	{
		$page_title='Task - Weekly';
		
		$user = \Auth::user();
		$role_id=$user->role_id;
		$user_code=$user->user_code;
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
	   $now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   $tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->get();
	   
	   
	   if($role_id==2)
		{
					
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('employee_id', '=', $user_code)->get();
		} 

       return view('admin.reports.task', compact('tasks','page_title'));
    }
	
	public function taskweekly_pending()
	{
		$page_title='Task - Pending';
		       
			   
		$user = \Auth::user();
		$role_id=$user->role_id;
		$user_code=$user->user_code;
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
	   $now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   $tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '!=' ,'Completed')->get();
	   
	   if($role_id==2)
		{
					
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '!=' ,'Completed')->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '!=' ,'Completed')->where('employee_id', '=', $user_code)->get();
		} 
		

       return view('admin.reports.task', compact('tasks','page_title'));
    }
	
	public function taskweekly_completed()
	{
		$page_title='Task - Completed';
		
		$user = \Auth::user();
		$role_id=$user->role_id;
		
		$user_code=$user->user_code;
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
	   $now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   $tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '=' ,'Completed')->get();

	   if($role_id==2)
		{
					
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '=' ,'Completed')->where('owner_id', '=', $user_code)->get();
		}
        else if($role_id==3)
		{
						
		$tasks = Taskmanager::whereBetween('meeting_date', [$weekStartDate, $weekEndDate])->where('progress_status', '=' ,'Completed')->where('employee_id', '=', $user_code)->get();
		} 
		
		
		
       return view('admin.reports.task', compact('tasks','page_title'));
    }

	
	//appointment_weekly
	
    public function appointment_weekly()
    {
		$page_title='Meeting This Week';
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
		//$appointments = WorkingHour::whereBetween('date', [$weekStartDate, $weekEndDate])->get();
		
		
		//           
		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		->whereBetween('date', array($weekStartDate, $weekEndDate))

        //->where('task_id', $id)
		->orderBy('h.id')
		->get();
		
		
		
	

       return view('admin.reports.index', compact('appointments','page_title'));
    }
	
	
	public function appointment_lastweekly()
    {
		$page_title='Meeting Last Week';
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   $currentweekDate = new DateTime($weekStartDate);
 
	
		$laskweekDate = $currentweekDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_start = $laskweekDate->format('Y-m-d');
		
		
		$currentweekendDate = new DateTime($weekEndDate);
 
	
		$laskweekendDate = $currentweekendDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_end = $laskweekendDate->format('Y-m-d');
		
		//$appointments = WorkingHour::whereBetween('date', [$lastweek_start, $lastweek_end])->get();
		

		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		->whereBetween('date', array($lastweek_start, $lastweek_end))

        //->where('task_id', $id)
		->orderBy('h.id')
		->get();
       return view('admin.reports.index', compact('appointments','page_title'));
    }
	
	
    public function appointment_total()
    {
		$page_title='Total Meeting';
		       
	   if (! Gate::allows('working_hour_access')) {
            return abort(401);
        }
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   $currentweekDate = new DateTime($weekStartDate);
 
	
		$laskweekDate = $currentweekDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_start = $laskweekDate->format('Y-m-d');
		
		
		$currentweekendDate = new DateTime($weekEndDate);
 
	
		$laskweekendDate = $currentweekendDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_end = $laskweekendDate->format('Y-m-d');
		
		//$appointments = WorkingHour::whereBetween('date', [$lastweek_start, $weekEndDate])->get();
		
		
		$appointments = DB::table('working_hours as h')
		->join('users as u', 'u.id', '=', 'h.owner_id')
		->select('u.name as owner_id','h.date','h.start_time','h.finish_time','h.task_name', 'h.id as id','h.status')
		->whereBetween('date', array($lastweek_start, $weekEndDate))

        //->where('task_id', $id)
		->orderBy('h.id')
		->get();
		
		
	

       return view('admin.reports.index', compact('appointments','page_title'));
    }
	
	
	public function task_status($id)
	{
		
		 if (! Gate::allows('taskmanager_access')) {
            return abort(401);
        }
		/*$task_history = DB::table('task_history')
                    ->where('task_id', $id)
					->groupBy('change_type')

                    ->get();
			
        */
		
		$task_history = DB::table('task_history as h')
		->join('task_manager as t', 't.id', '=', 'h.task_id')
		->select('t.item','h.*')
        ->where('task_id', $id)
		->orderBy('h.change_type')
		->get();
	
	
        return view('admin.taskmanager.remarks', compact('task_history'));
	}
}
