<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreUsersRequest;
use App\Http\Requests\Admin\UpdateUsersRequest;

use DB;

class ReportsController extends Controller
{
    /**
     * Display a listing of User.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('user_access')) {
            return abort(401);
        }

		
		
		
        $users = User::all();
		if(@$_REQUEST['role_id'] !='')
		{
			$user_id=$_REQUEST['role_id'];
			$users = User::where([
       'role_id' => $user_id,
       
		])->get();
        }			
        /*[
       'role_id' => 2,
       
		]*/
		//$users = User::where()->get();
		
		    $relations = [
            'roles' => \App\Role::get()->pluck('title', 'id')->prepend('Please select', ''),
			 'services' => \App\Service::get()->pluck('name', 'id'),
		];
		
		
		//return view('admin.users.index', compact('users'));
		
		//exit;
        return view('admin.users.index', compact('users'),$relations);
    }

	
	
	    public function task()
    {
		$page_title='Task - Reports';
		       
	   if (! Gate::allows('taskmanager_access')) {
            return abort(401);
        }
		
		$owner_id=@$_REQUEST['owner_id'];
		
		$employee_id=@$_REQUEST['employee_id'];
		
		$progress_status=@$_REQUEST['progress_status'];
		//print_r($owner_id);
		//exit;
		
		/*$today_date=date('Y-m-d');
		$tasks = Taskmanager::where('deadline', '=', $today_date)->get();
		
		$now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
	   
	   //$tasks = Taskmanager::whereBetween('deadline', [$weekStartDate, $weekEndDate])->get();
	   
	   
	   */
	   
	   		$user = \Auth::user();
			
       if($user->role_id==1)
        {	
		
	   $tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
            ->join('users as u', 'u.user_code', '=', 't.employee_id');
	    }
				else if($user->role_id ==2)
        {	
	
	    
			$tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
			->join('users as u', 'u.user_code', '=', 't.owner_id')
            ->where('u.user_code', '=', $user->user_code);

            
			
	
		
		}
		
		else if($user->role_id ==3)
        {	
	
	    
		$tasks1 = DB::table('task_manager as t' )
            ->select('t.company_id', 't.owner_id', 't.segment_id', 't.type_of_meeting', 
			't.deadline','t.review_date','t.progress_status','t.approved',
			'u.name as employee_id', 't.meeting_date','t.id')
			->join('users as u', 'u.user_code', '=', 't.employee_id')
            ->where('u.user_code', '=', $user->user_code);

            
	
	
		}
     		
          if($owner_id !='')
		  {
		   $tasks1->where('t.owner_id', '=', $owner_id);
		  }
		  if($employee_id !='')
		  {
		   $tasks1->where('t.employee_id', '=', $employee_id);
		  }
		  if($progress_status !='')
		  {
		   if($progress_status	=='DeadLine')  
		   {
			   
			   $tasks1->where('t.deadline', '<', date('Y-m-d'));
		   }
		   else
		   {   
		   $tasks1->where('t.progress_status', '=', $progress_status);
		   }
		  }

        $tasks =    $tasks1->get();
			
		
		        $relations = [
		   // 'owner' => \App\Owner::get(),
		   
		    'owner' => \App\User::where('role_id',2)->get()->pluck('name','user_code')->prepend('Please select', ''),
		    //'company' => \App\Company::get(),
		    //'segments' => \App\Segment::get(),
            'status' => \App\Status::get()->pluck('name', 'name')->prepend('Please select', '')->prepend('DeadLine', 'DeadLine'),
            'employees' => \App\User::where('role_id',3)->get()->pluck('name','user_code')->prepend('Please select', ''),
			//'meeting' => \App\Meeting::get(),
			'owner_id' => $owner_id
        ];
    
        //return view('admin.taskmanager.create', compact('segments') +$relations);

       return view('admin.reports.task_report_search', compact('tasks','page_title')+$relations);
    }
	
    /**
     * Show the form for creating new User.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('user_create')) {
            return abort(401);
        }
        $relations = [
            'roles' => \App\Role::get()->pluck('title', 'id')->prepend('Please select', ''),
			 'services' => \App\Service::get()->pluck('name', 'id'),
		];

        return view('admin.users.create', $relations);
    }

    /**
     * Store a newly created User in storage.
     *
     * @param  \App\Http\Requests\StoreUsersRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUsersRequest $request)
    {
        if (! Gate::allows('user_create')) {
            return abort(401);
        }
		
		
       // $user = User::create($request->all());

	    $user = User::create($request->only(['name', 'user_code', 'email', 'password', 'role_id']));
		
		$services_ids = [];
		foreach($request->services as $service) :
		$services_ids[] = $service;
		endforeach;
		$user->services()->attach($services_ids);


        return redirect()->route('admin.users.index');
    }


    /**
     * Show the form for editing User.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('user_edit')) {
            return abort(401);
        }
        $relations = [
            'roles' => \App\Role::get()->pluck('title', 'id')->prepend('Please select', ''),
        ];

        $user = User::findOrFail($id);

        return view('admin.users.edit', compact('user') + $relations);
    }

    /**
     * Update User in storage.
     *
     * @param  \App\Http\Requests\UpdateUsersRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateUsersRequest $request, $id)
    {
        if (! Gate::allows('user_edit')) {
            return abort(401);
        }
        $user = User::findOrFail($id);
        $user->update($request->all());



        return redirect()->route('admin.users.index');
    }


    /**
     * Display User.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (! Gate::allows('user_view')) {
            return abort(401);
        }
        $relations = [
            'roles' => \App\Role::get()->pluck('title', 'id')->prepend('Please select', ''),
        ];

        $user = User::findOrFail($id);

        return view('admin.users.show', compact('user') + $relations);
    }


    /**
     * Remove User from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('user_delete')) {
            return abort(401);
        }
        $user = User::findOrFail($id);
        $user->delete();

        return redirect()->route('admin.users.index');
    }

    /**
     * Delete all selected User at once.
     *
     * @param Request $request
     */
    public function massDestroy(Request $request)
    {
        if (! Gate::allows('user_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = User::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }

}
