<?php

namespace App\Http\Controllers\Admin;

use App\Owner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreOwnersRequest;
use App\Http\Requests\Admin\UpdateOwnersRequest;

class OwnersController extends Controller
{
    /**
     * Display a listing of Owner.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('owner_access')) {
            return abort(401);
        }

        $owners = Owner::all();

        return view('admin.owners.index', compact('owners'));
    }

    /**
     * Show the form for creating new Owner.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('owner_create')) {
            return abort(401);
        }
        return view('admin.owners.create');
    }

    /**
     * Store a newly created Owner in storage.
     *
     * @param  \App\Http\Requests\StoreOwnersRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOwnersRequest $request)
    {
        if (! Gate::allows('owner_create')) {
            return abort(401);
        }
        $owner = Owner::create($request->all());



        return redirect()->route('admin.owners.index');
    }


    /**
     * Show the form for editing Owner.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('owner_edit')) {
            return abort(401);
        }
        $owner = Owner::findOrFail($id);

        return view('admin.owners.edit', compact('owner'));
    }

    /**
     * Update Owner in storage.
     *
     * @param  \App\Http\Requests\UpdateOwnersRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOwnersRequest $request, $id)
    {
        if (! Gate::allows('owner_edit')) {
            return abort(401);
        }
        $owner = Owner::findOrFail($id);
        $owner->update($request->all());



        return redirect()->route('admin.owners.index');
    }


    /**
     * Display Owner.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (! Gate::allows('owner_view')) {
            return abort(401);
        }
       /* $relations = [
            'appointments' => \App\Appointment::where('owner_id', $id)->get(),
        ];
       */
        $owner = Owner::findOrFail($id);

        return view('admin.owners.show', compact('owner') );
    }


    /**
     * Remove Owner from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('owner_delete')) {
            return abort(401);
        }
        $owner = Owner::findOrFail($id);
        $owner->delete();

        return redirect()->route('admin.owners.index');
    }

    /**
     * Delete all selected Owner at once.
     *
     * @param Request $request
     */
    public function massDestroy(Request $request)
    {
        if (! Gate::allows('owner_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = Owner::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }

}
